package ru.yandex.solomon.model.point.column;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.EnumMap;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.lang.EnumMapUtils;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class StockpileColumnSetMh {

    public static final Class<?> primitiveParamType = int.class;

    private static boolean isInColumnSetImpl(int mask, int columnMask) {
        return (mask & columnMask) != 0;
    }

    private static final MethodHandle isInColumnSetImpl;

    static {
        try {
            isInColumnSetImpl = MethodHandles.lookup().findStatic(
                StockpileColumnSetMh.class,
                "isInColumnSetImpl",
                MethodType.methodType(boolean.class, primitiveParamType, primitiveParamType));
        } catch (NoSuchMethodException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    // int -> bool
    private static MethodHandle makeIsInColumnSet(StockpileColumn c) {
        return MethodHandles.insertArguments(isInColumnSetImpl, 1, c.mask());
    }

    private static final EnumMap<StockpileColumn, MethodHandle> isInColumnSet =
        EnumMapUtils.fill(StockpileColumn.class, StockpileColumnSetMh::makeIsInColumnSet);

    public static MethodHandle isInColumnSetImpl(StockpileColumn c) {
        return isInColumnSet.get(c);
    }

}
