package ru.yandex.solomon.model.point.column;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.commune.mh.builder.MhCall;
import ru.yandex.commune.mh.builder.MhExpr;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class StockpileColumnSetTypeMh {

    public static final Class<?> primitiveClass = int.class;

    @Nonnull
    private static Field findField(Class<?> source) {
        List<Field> fields = Arrays.stream(source.getDeclaredFields())
            .filter(s -> s.getAnnotation(StockpileColumnSetType.class) != null)
            .collect(Collectors.toList());
        if (fields.size() != 1) {
            throw new RuntimeException("not found in: " + source);
        }
        return fields.iterator().next();
    }

    public static MhExpr get(MhExpr source) {
        // TODO: validate mask
        return MhCall.getInstanceField(source, findField(source.exprType())).assertType(int.class);
    }

}
