package ru.yandex.solomon.model.point.column;

import java.util.Arrays;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.commune.mh.builder.MhExpr;
import ru.yandex.commune.mh.builder.MhSeq;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class StockpileColumnsMh {

    public static MhExpr invokeAllExprs(Function<StockpileColumn, MhExpr> f) {
        return MhSeq.seq(Arrays.stream(StockpileColumn.values()).map(f).toArray(MhExpr[]::new));
    }

    public static MhExpr invokeAllExprsIfColumnIn(MhExpr columnSetMask, Function<StockpileColumn, MhExpr> f) {
        columnSetMask.assertType(StockpileColumnSetTypeMh.primitiveClass);

        return invokeAllExprs(c -> {
            return f.apply(c).onlyIf(c.mh().isInSet(columnSetMask));
        });
    }

}
