package ru.yandex.solomon.model.point.column;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.commune.mh.builder.MhExpr;
import ru.yandex.commune.mh.builder.MhExprBool;
import ru.yandex.commune.mh.builder.MhIfThenElse;
import ru.yandex.commune.mh.builder.MhValueTarget;
import ru.yandex.misc.lang.Validate;


/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class StockpileMergeMh {

    @Nonnull
    private static MhExpr mergeFields(
        List<MhExpr> a, List<MhExpr> b,
        Function<StockpileColumn, MhExpr> hasColumn,
        List<MhValueTarget> setField)
    {
        EnumMap<StockpileColumn, List<MhExpr>> ag = StockpileColumn.groupByColumns(a);
        EnumMap<StockpileColumn, List<MhExpr>> bg = StockpileColumn.groupByColumns(b);

        return StockpileColumnsMh.invokeAllExprs(c -> {
            MhExpr cond = hasColumn.apply(c);
            List<MhExpr> r = c.mh().merge(ag.get(c), bg.get(c));
            Validate.equals(c.dataFields().size(), r.size());
            MhExpr set = c.mh().invokeAllFields(d -> {
                MhExpr mhExpr = r.get(d.indexInColumn());
                return setField.get(d.ordinal()).set(mhExpr);
            });
            return set.onlyIf(cond);
        });
    }

    private static MhExpr setFieldsIfSet(
        List<MhExpr> source,
        Function<StockpileColumn, MhExpr> hasColumn,
        List<MhValueTarget> setField)
    {
        return StockpileColumnFieldMh.invokeAllExprs(d -> {
            return setField.get(d.ordinal()).set(source.get(d.ordinal()))
                .onlyIf(hasColumn.apply(d.column));
        });
    }

    @Nonnull
    public static MhExpr merge(
        List<MhExpr> a, List<MhExpr> b,
        Function<StockpileColumn, MhExpr> hasColumn,
        List<MhValueTarget> setField)
    {
        MhExpr merge = MhExprBool.and(
            hasColumn.apply(StockpileColumn.MERGE),
            b.get(StockpileColumnField.MERGE.ordinal()));

        return MhIfThenElse.ifThenElse(
            merge,
            mergeFields(a, b, hasColumn, setField),
            setFieldsIfSet(b, hasColumn, setField));
    }

}
