package ru.yandex.solomon.model.point.column;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.summary.ImmutableSummaryDoubleSnapshot;
import ru.yandex.monlib.metrics.summary.SummaryDoubleSnapshot;
import ru.yandex.solomon.model.type.SummaryDouble;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SummaryDoubleColumn extends ColumnImplBase {
    public static final SummaryDoubleColumn C = new SummaryDoubleColumn();
    public static final SummaryDoubleSnapshot DEFAULT_VALUE = null;
    public static final int mask = StockpileColumn.DSUMMARY.mask();

    private SummaryDoubleColumn() {
        super(StockpileColumn.DSUMMARY);
    }

    @Nullable
    public static SummaryDoubleSnapshot merge(@Nullable SummaryDoubleSnapshot left, @Nullable SummaryDoubleSnapshot right) {
        if (isNull(left)) {
            return right;
        }

        if (isNull(right)) {
            return left;
        }

        long count = left.getCount() + right.getCount();
        double sum = left.getSum() + right.getSum();
        double max = Math.max(left.getMax(), right.getMax());
        double min = Math.min(left.getMin(), right.getMin());
        double last = right.getLast();
        return SummaryDouble.newInstance(count, sum, min, max, last);
    }

    public static SummaryDoubleSnapshot copy(@Nullable SummaryDoubleSnapshot summary) {
        if (summary == null) {
            return null;
        }

        if (summary instanceof ImmutableSummaryDoubleSnapshot) {
            return summary;
        }

        return new ImmutableSummaryDoubleSnapshot(summary.getCount(), summary.getSum(), summary.getMin(), summary.getMax(), summary.getLast());
    }

    public static SummaryDoubleSnapshot copy(@Nullable SummaryDoubleSnapshot source, @Nullable SummaryDoubleSnapshot target) {
        if (source == null) {
            return null;
        }

        return SummaryDouble.orNew(target)
            .setCount(source.getCount())
            .setSum(source.getSum())
            .setMin(source.getMin())
            .setMax(source.getMax())
            .setLast(source.getLast());
    }

    public static void recycle(@Nullable SummaryDoubleSnapshot summary) {
        if (summary == null) {
            return;
        }

        if (summary instanceof SummaryDouble) {
            ((SummaryDouble) summary).recycle();
        }
    }

    private static boolean isNull(@Nullable SummaryDoubleSnapshot summary) {
        return summary == null;
    }

    public static String toString(@Nullable SummaryDoubleSnapshot snapshot) {
        return String.valueOf(snapshot);
    }
}
