package ru.yandex.solomon.model.point.column;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.summary.ImmutableSummaryInt64Snapshot;
import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;
import ru.yandex.solomon.model.type.SummaryInt64;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SummaryInt64Column extends ColumnImplBase {
    public static final SummaryInt64Column C = new SummaryInt64Column();
    public static final SummaryInt64Snapshot DEFAULT_VALUE = null;
    public static final int mask = StockpileColumn.ISUMMARY.mask();

    private SummaryInt64Column() {
        super(StockpileColumn.ISUMMARY);
    }

    @Nullable
    public static SummaryInt64Snapshot merge(@Nullable SummaryInt64Snapshot left, @Nullable SummaryInt64Snapshot right) {
        if (isNull(left)) {
            return right;
        }

        if (isNull(right)) {
            return left;
        }

        long count = left.getCount() + right.getCount();
        long sum = left.getSum() + right.getSum();
        long max = Math.max(left.getMax(), right.getMax());
        long min = Math.min(left.getMin(), right.getMin());
        long last = right.getLast();
        return SummaryInt64.newInstance(count, sum, min, max, last);
    }

    public static SummaryInt64Snapshot copy(@Nullable SummaryInt64Snapshot summary) {
        if (summary == null) {
            return null;
        }

        if (summary instanceof ImmutableSummaryInt64Snapshot) {
            return summary;
        }

        return new ImmutableSummaryInt64Snapshot(summary.getCount(), summary.getSum(), summary.getMin(), summary.getMax(), summary.getLast());
    }

    public static SummaryInt64Snapshot copy(@Nullable SummaryInt64Snapshot source, @Nullable SummaryInt64Snapshot target) {
        if (source == null) {
            return null;
        }

        return SummaryInt64.orNew(target)
            .setCount(source.getCount())
            .setSum(source.getSum())
            .setMin(source.getMin())
            .setMax(source.getMax())
            .setLast(source.getLast());
    }

    public static void recycle(@Nullable SummaryInt64Snapshot summary) {
        if (summary == null) {
            return;
        }

        if (summary instanceof SummaryInt64) {
            ((SummaryInt64) summary).recycle();
        }
    }

    private static boolean isNull(@Nullable SummaryInt64Snapshot summary) {
        return summary == null;
    }

    public static String toString(@Nullable SummaryInt64Snapshot snapshot) {
        return String.valueOf(snapshot);
    }
}
