package ru.yandex.solomon.model.point.column;

import ru.yandex.solomon.util.time.InstantUtils;

/**
 * @author Stepan Koltsov
 */
public class TsColumn extends ColumnImplBase {

    public static final TsColumn C = new TsColumn();

    public static final StockpileColumn column = StockpileColumn.TS;

    public static final long DEFAULT_VALUE = 0;

    public static final int mask = StockpileColumn.TS.mask();

    private TsColumn() {
        super(StockpileColumn.TS);
    }

    public static boolean isValid(long tsMillis) {
        return tsMillis > 0;
    }

    public static void validateOrThrow(long tsMillis) {
        if (!isValid(tsMillis)) {
            throw new RuntimeException("Non-positive timestamp is not allowed: " + tsMillis);
        }
    }

    public static long merge(long a, long b) {
        if (a != b) {
            throw new IllegalArgumentException("Cannot merge timestamps: " + a + "!=" + b);
        }
        return a;
    }

    public static long copy(long value) {
        return value;
    }

    public static String toString(long value) {
        return InstantUtils.formatToMillis(value);
    }
}
