package ru.yandex.solomon.model.point.column;

import java.time.Instant;
import java.util.Random;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.random.Random2;
import ru.yandex.solomon.util.time.InstantUtils;


/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class TsRandomData {

    private static final long ts0 = Instant.parse("2015-11-12T13:14:15Z").toEpochMilli();

    private static long randomMillis(Random random) {
        long shift = new Random2(random).nextLong(InstantUtils.NOT_AFTER - InstantUtils.NOT_BEFORE);
        return InstantUtils.NOT_BEFORE + shift;
    }

    private static long randomSeconds(Random random) {
        return randomMillis(random) / 1000 * 1000;
    }

    public static long randomTs(Random random) {
        long ts;
        do {
            ts = genTs(random);
        } while (!InstantUtils.isGoodMillis(ts));
        return ts;
    }

    private static long genTs(Random random) {
        switch (random.nextInt(4)) {
            case 0: return randomMillis(random);
            case 1: return randomSeconds(random);
            case 2: return ts0 + random.nextInt(10) * 1000;
            case 3: return ts0 + random.nextInt(10) * 1000 + 333;
            default: throw new IllegalStateException("unreachable");
        }
    }
}
