package ru.yandex.solomon.model.point.column;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ValueObject {

    public static final ValueObject NaN = new ValueObject(Double.NaN, ValueColumn.DEFAULT_DENOM);
    public static final ValueObject Zero = new ValueObject(0, ValueColumn.DEFAULT_DENOM);

    public final double num;
    public final long denom;

    public ValueObject(double num, long denom) {
        this.num = num;
        this.denom = denom;
    }

    public boolean isDenomOne() {
        return ValueColumn.isOne(denom);
    }

    public double divide() {
        return ValueColumn.divide(num, denom);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ValueObject that = (ValueObject) o;

        if (Double.compare(that.num, num) != 0) return false;
        return denom == that.denom;
    }

    @Override
    public int hashCode() {
        int result;
        long temp;
        temp = Double.doubleToLongBits(num);
        result = (int) (temp ^ (temp >>> 32));
        result = 31 * result + (int) (denom ^ (denom >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return ValueColumn.toString(num, denom);
    }

    public boolean isNaN() {
        return Double.isNaN(divide());
    }
}
