package ru.yandex.solomon.model.point.column;

import java.util.Random;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ValueRandomData {
    private static final RandomDoubleFunction[] NUM_FUNCTIONS = {
        random -> random.nextBoolean() ? 0 : 1,
        Random::nextInt,
        random -> random.nextInt(200) - 100,
        Random::nextDouble,
        random -> Double.longBitsToDouble(random.nextLong()),
        random -> Double.NaN,
        random -> Double.POSITIVE_INFINITY,
        random -> Double.NEGATIVE_INFINITY,
        random -> Double.MAX_VALUE,
        random -> Double.MIN_NORMAL,
        random -> Double.longBitsToDouble(random.nextInt(5)),
        random -> Double.longBitsToDouble(1 << random.nextInt(64)),
    };

    private static final RandomLongFunction[] DENOM_FUNCTIONS = {
        random -> 0L,
        random -> 1000L,
        random -> 15000L,
        random -> random.nextInt() & 0x7fffffff,
    };


    public static double randomNum(Random random) {
        return NUM_FUNCTIONS[random.nextInt(NUM_FUNCTIONS.length)].apply(random);
    }

    public static long randomDenom(Random random) {
        return DENOM_FUNCTIONS[random.nextInt(DENOM_FUNCTIONS.length)].apply(random);
    }

    private interface RandomDoubleFunction {
        double apply(Random random);
    }

    private interface RandomLongFunction {
        long apply(Random random);
    }
}
