package ru.yandex.solomon.model.point.predicate;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.AggrPointData;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
@FunctionalInterface
public interface AggrPointPredicate {

    AggrPointPredicate TRUE = (mask, pointData) -> true;

    boolean testPointData(int columnSetMask, AggrPointData p);

    default boolean testPoint(AggrPoint p) {
        return testPointData(p.columnSetMask(), p);
    }

}
