package ru.yandex.solomon.model.protobuf;

import java.util.Objects;

import javax.annotation.Nullable;

import ru.yandex.solomon.model.type.Histogram;

/**
 * @author Vladimir Gordiychuk
 */
public final class HistogramConverter {

    public static ru.yandex.solomon.model.protobuf.Histogram toProto(@Nullable Histogram histogram) {
        if (histogram == null) {
            return ru.yandex.solomon.model.protobuf.Histogram.getDefaultInstance();
        }

        var builder = ru.yandex.solomon.model.protobuf.Histogram.newBuilder();
        builder.setDenom(histogram.getDenom());
        for (int index = 0; index < histogram.count(); index++) {
            builder.addBounds(histogram.upperBound(index));
            builder.addBuckets(histogram.value(index));
        }
        return builder.build();
    }

    @Nullable
    public static Histogram fromProto(ru.yandex.solomon.model.protobuf.Histogram proto) {
        if (Objects.equals(proto, ru.yandex.solomon.model.protobuf.Histogram.getDefaultInstance())) {
            return null;
        }

        if (proto.getBoundsCount() != proto.getBucketsCount()) {
            throw new IllegalArgumentException("boundsSize(" + proto.getBoundsCount() + ") != bucketsSize(" + proto.getBucketsCount() + ")");
        }

        Histogram histogram = Histogram.newInstance();
        histogram.setDenom(proto.getDenom());
        for (int index = 0; index < proto.getBucketsCount(); index++) {
            histogram.setUpperBound(index, proto.getBounds(index));
            histogram.setBucketValue(index, proto.getBuckets(index));
        }
        return histogram;
    }
}
