package ru.yandex.solomon.model.protobuf;

import java.util.stream.IntStream;

import javax.annotation.Nullable;

import ru.yandex.solomon.model.type.LogHistogram;


/**
 * @author Vladimir Gordiychuk
 */
public class LogHistogramConverter {
    @Nullable
    public static LogHistogram fromProto(ru.yandex.solomon.model.protobuf.LogHistogram proto) {
        if (proto == ru.yandex.solomon.model.protobuf.LogHistogram.getDefaultInstance()) {
            return null;
        }

        var histogramBuilder = LogHistogram.newBuilder()
            .setBuckets(IntStream.range(0, proto.getBucketsCount())
                .mapToDouble(proto::getBuckets)
                .toArray());

        histogramBuilder.setCountZero(proto.getZeroes());
        histogramBuilder.setStartPower(proto.getStartPower());
        if (proto.getMaxBucketsSize() != 0) {
            histogramBuilder.setMaxBucketsSize(proto.getMaxBucketsSize());
        }

        if (proto.getBase() != 0) {
            histogramBuilder.setBase(proto.getBase());
        }

        return histogramBuilder.build();
    }

    public static ru.yandex.solomon.model.protobuf.LogHistogram toProto(@Nullable LogHistogram logHistogram) {
        if (logHistogram == null) {
            return ru.yandex.solomon.model.protobuf.LogHistogram.getDefaultInstance();
        }

        var builder = ru.yandex.solomon.model.protobuf.LogHistogram.newBuilder()
                .setBase(logHistogram.getBase())
                .setMaxBucketsSize(logHistogram.getMaxBucketsSize())
                .setZeroes((int) Math.min(logHistogram.getCountZero(), Integer.MAX_VALUE)) // TODO: change format
                .setStartPower(logHistogram.getStartPower());

        for (int index = 0; index < logHistogram.countBucket(); index++) {
            double bucketValue = logHistogram.getBucketValue(index);
            builder.addBuckets(bucketValue);
        }

        return builder.build();
    }
}
