package ru.yandex.solomon.model.protobuf;

import java.util.Map;
import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;


/**
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
public final class MetricTypeConverter {
    private static final ru.yandex.solomon.model.protobuf.MetricType[] BY_ORDINAL;
    private static final ru.yandex.monlib.metrics.MetricType[] BY_NUMBER;

    static {
        try {
            var mapping = Map.of(
                    ru.yandex.monlib.metrics.MetricType.UNKNOWN, ru.yandex.solomon.model.protobuf.MetricType.METRIC_TYPE_UNSPECIFIED,
                    ru.yandex.monlib.metrics.MetricType.DGAUGE, ru.yandex.solomon.model.protobuf.MetricType.DGAUGE,
                    ru.yandex.monlib.metrics.MetricType.IGAUGE, ru.yandex.solomon.model.protobuf.MetricType.IGAUGE,
                    ru.yandex.monlib.metrics.MetricType.COUNTER, ru.yandex.solomon.model.protobuf.MetricType.COUNTER,
                    ru.yandex.monlib.metrics.MetricType.RATE, ru.yandex.solomon.model.protobuf.MetricType.RATE,
                    ru.yandex.monlib.metrics.MetricType.HIST, ru.yandex.solomon.model.protobuf.MetricType.HIST,
                    ru.yandex.monlib.metrics.MetricType.HIST_RATE, ru.yandex.solomon.model.protobuf.MetricType.HIST_RATE,
                    ru.yandex.monlib.metrics.MetricType.ISUMMARY, ru.yandex.solomon.model.protobuf.MetricType.ISUMMARY,
                    ru.yandex.monlib.metrics.MetricType.DSUMMARY, ru.yandex.solomon.model.protobuf.MetricType.DSUMMARY,
                    ru.yandex.monlib.metrics.MetricType.LOG_HISTOGRAM, ru.yandex.solomon.model.protobuf.MetricType.LOG_HISTOGRAM
            );

            var byNumber = new ru.yandex.monlib.metrics.MetricType[mapping.size()];
            var byOrdinal = new ru.yandex.solomon.model.protobuf.MetricType[mapping.size()];
            for (var entry : mapping.entrySet()) {
                byNumber[entry.getValue().getNumber()] = entry.getKey();
                byOrdinal[entry.getKey().ordinal()] = entry.getValue();
            }

            BY_ORDINAL = byOrdinal;
            BY_NUMBER = byNumber;
            for (var item : BY_ORDINAL) {
                Objects.requireNonNull(item);
            }

            for (var item : BY_NUMBER) {
                Objects.requireNonNull(item);
            }
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private MetricTypeConverter() {}

    public static ru.yandex.monlib.metrics.MetricType fromProto(ru.yandex.solomon.model.protobuf.MetricType type) {
        if (type == ru.yandex.solomon.model.protobuf.MetricType.UNRECOGNIZED) {
            return ru.yandex.monlib.metrics.MetricType.UNKNOWN;
        }

        int num = type.getNumber();
        if (num < 0 || num >= BY_NUMBER.length) {
            return ru.yandex.monlib.metrics.MetricType.UNKNOWN;
        }

        return BY_NUMBER[num];
    }

    @Nullable
    public static ru.yandex.solomon.model.protobuf.MetricType toProto(ru.yandex.monlib.metrics.MetricType type) {
        if (type.ordinal() >= BY_NUMBER.length) {
            return null;
        }

        return BY_ORDINAL[type.ordinal()];
    }

    @Nonnull
    public static ru.yandex.solomon.model.protobuf.MetricType toNotNullProto(ru.yandex.monlib.metrics.MetricType type) {
        return BY_ORDINAL[type.ordinal()];
    }
}
