package ru.yandex.solomon.model.protobuf;

import javax.annotation.Nullable;

import ru.yandex.monlib.metrics.summary.ImmutableSummaryDoubleSnapshot;
import ru.yandex.monlib.metrics.summary.ImmutableSummaryInt64Snapshot;
import ru.yandex.monlib.metrics.summary.SummaryDoubleSnapshot;
import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;

/**
 * @author Vladimir Gordiychuk
 */
public final class SummaryConverter {
    private SummaryConverter() {
    }

    public static SummaryInt64 toProto(@Nullable SummaryInt64Snapshot summary) {
        if (summary == null) {
            return SummaryInt64.getDefaultInstance();
        }

        return SummaryInt64.newBuilder()
                .setCount(summary.getCount())
                .setSum(summary.getSum())
                .setMin(summary.getMin())
                .setMax(summary.getMax())
                .setLast(summary.getLast())
                .build();
    }

    public static SummaryDouble toProto(@Nullable SummaryDoubleSnapshot summary) {
        if (summary == null) {
            return SummaryDouble.getDefaultInstance();
        }

        return SummaryDouble.newBuilder()
                .setCount(summary.getCount())
                .setSum(summary.getSum())
                .setMin(summary.getMin())
                .setMax(summary.getMax())
                .setLast(summary.getLast())
                .build();
    }

    @Nullable
    public static SummaryInt64Snapshot fromProto(SummaryInt64 proto) {
        if (proto == null) {
            return null;
        }

        return new ImmutableSummaryInt64Snapshot(proto.getCount(), proto.getSum(), proto.getMin(), proto.getMax(), proto.getLast());
    }

    @Nullable
    public static SummaryDoubleSnapshot fromProto(SummaryDouble proto) {
        if (proto == null) {
            return null;
        }

        return new ImmutableSummaryDoubleSnapshot(proto.getCount(), proto.getSum(), proto.getMin(), proto.getMax(), proto.getLast());
    }
}
