package ru.yandex.solomon.model.timeseries;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AggrGraphDataArrayListViewIterator extends AggrGraphDataListIterator {

    private final AggrGraphDataArrayListView view;
    private int pos = 0;

    public AggrGraphDataArrayListViewIterator(AggrGraphDataArrayListView view) {
        super(view.columnSetMask());
        this.view = view;
    }

    @Override
    public boolean next(AggrPoint target) {
        if (pos == view.length()) {
            return false;
        }

        target.columnSet = columnSetMask();
        view.getDataTo(pos, target);
        ++pos;
        return true;
    }

    @Override
    public int estimatePointsCount() {
        return view.length() - pos;
    }
}
