package ru.yandex.solomon.model.timeseries;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.column.HasColumnSet;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public interface AggrGraphDataIterable extends HasColumnSet {
    /**
     * @return points count
     */
    int getRecordCount();

    int elapsedBytes();

    default boolean isEmpty() {
        return getRecordCount() == 0;
    }

    AggrGraphDataListIterator iterator();
}
