package ru.yandex.solomon.model.timeseries;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.HasColumnSet;
import ru.yandex.solomon.model.point.column.StockpileColumnSetType;
import ru.yandex.solomon.model.timeseries.iterator.GenericIterator;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public abstract class AggrGraphDataListIterator implements HasColumnSet, GenericIterator<AggrPoint> {
    @StockpileColumnSetType
    public final int columnSet;

    public AggrGraphDataListIterator(int columnSetMask) {
        this.columnSet = columnSetMask;
    }

    @Override
    public abstract boolean next(AggrPoint target);

    /**
     * @return estimated count points at this iterator, or -1 if not available estimate count
     */
    @Override
    public int estimatePointsCount() {
        return -1;
    }

    @Override
    public int columnSetMask() {
        return columnSet;
    }
}
