package ru.yandex.solomon.model.timeseries;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.column.StockpileColumns;
import ru.yandex.solomon.model.point.predicate.AggrPointPredicate;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class AggrGraphDataLists {
    private AggrGraphDataLists() {
    }


    @Nonnull
    public static GraphDataArrayList toGraphDataArrayList(AggrGraphDataIterable list) {
        var dataType = StockpileColumns.typeByMask(list.columnSetMask());
        return toAggrListUnsorted(list).toGraphDataArrayList(dataType);
    }

    @Nonnull
    public static AggrGraphDataArrayList toAggrListUnsorted(AggrGraphDataIterable list) {
        int columnSetMask = list.columnSetMask();
        AggrGraphDataArrayList r = new AggrGraphDataArrayList(columnSetMask, list.getRecordCount());
        r.addAllFrom(list.iterator());
        return r;
    }

    @Nonnull
    public static AggrGraphDataArrayList toFilteredList(AggrGraphDataIterable list, AggrPointPredicate p) {
        return AggrGraphDataArrayList.of(FilteringAggrGraphDataIterator.of(list.iterator(), p));
    }

}
