package ru.yandex.solomon.model.timeseries;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.AggrPointData;
import ru.yandex.solomon.model.point.column.StockpileColumnSetType;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface AggrGraphDataSink {
    default int getRecordCount() {
        return 0;
    }

    /**
     * @param minCapacity total expected capacity to store in structure
     */
    default void ensureCapacity(@StockpileColumnSetType int columnSet, int minCapacity) {}
    void addRecordData(@StockpileColumnSetType int columnSet, AggrPointData data);

    default void addRecord(AggrPoint point) {
        addRecordData(point.columnSetMask(), point);
    }

    void addAllFrom(AggrGraphDataListIterator iterator);

    default void addAll(AggrGraphDataIterable source) {
        int newCapacity = getRecordCount() + source.getRecordCount();
        ensureCapacity(source.columnSetMask(), newCapacity);
        addAllFrom(source.iterator());
    }
}
