package ru.yandex.solomon.model.timeseries;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;

import ru.yandex.solomon.model.point.column.StockpileColumnSet;

/**
 * @author Vladimir Gordiychuk
 */
public class ConcatAggrGraphDataIterable implements AggrGraphDataIterable {
    private final List<AggrGraphDataIterable> source;

    private ConcatAggrGraphDataIterable(List<AggrGraphDataIterable> chunks) {
        this.source = chunks;
    }

    public static AggrGraphDataIterable of(List<AggrGraphDataIterable> source) {
        if (source.isEmpty()) {
            return AggrGraphDataArrayList.empty();
        }

        if (source.size() == 1) {
            return source.get(0);
        }

        return new ConcatAggrGraphDataIterable(source);
    }

    @Override
    public int getRecordCount() {
        return source.stream()
            .mapToInt(AggrGraphDataIterable::getRecordCount)
            .sum();
    }

    @Override
    public int elapsedBytes() {
        return source.stream()
            .mapToInt(AggrGraphDataIterable::elapsedBytes)
            .sum();
    }

    @Nonnull
    @Override
    public AggrGraphDataListIterator iterator() {
        return ConcatAggrGraphDataIterator.of(source.stream()
            .map(AggrGraphDataIterable::iterator)
            .collect(Collectors.toList()));
    }

    @Override
    public int columnSetMask() {
        return source.stream()
            .mapToInt(AggrGraphDataIterable::columnSetMask)
            .reduce(StockpileColumnSet.empty.columnSetMask(), (left, right) -> left | right);
    }
}
