package ru.yandex.solomon.model.timeseries;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class ConcatAggrGraphDataIterator extends AggrGraphDataListIterator {
    private final List<AggrGraphDataListIterator> iterators;
    private int index;

    private ConcatAggrGraphDataIterator(int columnSetMask, List<AggrGraphDataListIterator> iterators) {
        super(columnSetMask);
        this.iterators = iterators;
    }

    public static AggrGraphDataListIterator of(List<AggrGraphDataListIterator> sources) {
        if (sources.size() == 1) {
            return sources.get(0);
        }

        int mask = 0;
        for (var it : sources) {
            mask |= it.columnSetMask();
        }

        return new ConcatAggrGraphDataIterator(mask, sources);
    }

    @Override
    public int estimatePointsCount() {
        int sum = 0;
        for (var it : iterators) {
            var size = it.estimatePointsCount();
            if (size == -1) {
                return -1;
            }
            sum += size;
        }
        return sum;
    }

    @Override
    public boolean next(AggrPoint target) {
        while (index < iterators.size()) {
            var it = iterators.get(index);
            if (it.next(target)) {
                return true;
            }

            index++;
        }
        return false;
    }
}
