package ru.yandex.solomon.model.timeseries;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.StockpileColumnSet;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class EmptyAggrGraphDataIterator extends AggrGraphDataListIterator {
    public static final AggrGraphDataListIterator INSTANCE =
            new EmptyAggrGraphDataIterator(StockpileColumnSet.empty.columnSetMask());

    public EmptyAggrGraphDataIterator(int columnSetMask) {
        super(columnSetMask);
    }

    @Override
    public boolean next(AggrPoint target) {
        return false;
    }

    @Override
    public int estimatePointsCount() {
        return 0;
    }
}
