package ru.yandex.solomon.model.timeseries;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class FilteringAfterAggrGraphDataIterator extends AggrGraphDataListIterator {
    private final AggrGraphDataListIterator iterator;
    private final long afterTsMillis;

    /**
     * @param iterator source iterator
     * @param afterTsMillis inclusive filter ts greater or equal to
     */
    public FilteringAfterAggrGraphDataIterator(AggrGraphDataListIterator iterator, long afterTsMillis) {
        super(iterator.columnSetMask());
        this.iterator = iterator;
        this.afterTsMillis = afterTsMillis;
    }

    @Override
    public boolean next(AggrPoint target) {
        if (iterator.next(target)) {
            return target.tsMillis < afterTsMillis;
        }
        return false;
    }

    @Override
    public int estimatePointsCount() {
        return iterator.estimatePointsCount();
    }
}
