package ru.yandex.solomon.model.timeseries;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.predicate.AggrPointPredicate;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class FilteringAggrGraphDataIterator extends AggrGraphDataListIterator {
    private AggrPointPredicate predicate;
    private AggrGraphDataListIterator source;

    public FilteringAggrGraphDataIterator(AggrGraphDataListIterator source, AggrPointPredicate predicate) {
        super(source.columnSetMask());
        this.source = source;
        this.predicate = predicate;
    }

    public static AggrGraphDataListIterator of(AggrGraphDataListIterator source, AggrPointPredicate predicate) {
        if (predicate == AggrPointPredicate.TRUE) {
            return source;
        }

        return new FilteringAggrGraphDataIterator(source, predicate);
    }

    @Override
    public int estimatePointsCount() {
        return source.estimatePointsCount();
    }

    @Override
    public boolean next(AggrPoint target) {
        while (source.next(target)) {
            if (predicate.testPoint(target)) {
                return true;
            }
        }

        return false;
    }
}
