package ru.yandex.solomon.model.timeseries;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class FilteringBeforeAggrGraphDataIterator extends AggrGraphDataListIterator {
    private final AggrGraphDataListIterator iterator;
    private final long beforeTsMillis;

    public FilteringBeforeAggrGraphDataIterator(AggrGraphDataListIterator iterator, long beforeTsMillis) {
        super(iterator.columnSetMask());
        this.iterator = iterator;
        this.beforeTsMillis = beforeTsMillis;
    }

    public static AggrGraphDataListIterator of(long deleteBefore, AggrGraphDataListIterator iterator) {
        if (deleteBefore == 0) {
            return iterator;
        } else if (deleteBefore == 1) {
            return new EmptyAggrGraphDataIterator(iterator.columnSetMask());
        } else {
            return new FilteringBeforeAggrGraphDataIterator(iterator, deleteBefore);
        }
    }

    @Override
    public boolean next(AggrPoint target) {
        while (iterator.next(target)) {
            if (target.tsMillis >= beforeTsMillis) {
                return true;
            }
        }

        return false;
    }

    @Override
    public int estimatePointsCount() {
        return iterator.estimatePointsCount();
    }
}
