package ru.yandex.solomon.model.timeseries;

import javax.annotation.Nonnull;

import ru.yandex.solomon.model.point.column.StockpileColumn;

/**
 * @author Vladimir Gordiychuk
 */
public class GraphDataAsAggrIterable implements AggrGraphDataIterable {
    private final GraphData source;

    public GraphDataAsAggrIterable(GraphData source) {
        this.source = source;
    }

    @Nonnull
    @Override
    public AggrGraphDataListIterator iterator() {
        return new GraphDataAsAggrIterator(source);
    }

    @Override
    public int columnSetMask() {
        return StockpileColumn.TS.mask() | StockpileColumn.VALUE.mask();
    }

    @Override
    public int getRecordCount() {
        return source.length();
    }

    @Override
    public int elapsedBytes() {
        return source.length() * 2;
    }
}
