package ru.yandex.solomon.model.timeseries;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.StockpileColumn;
import ru.yandex.solomon.model.point.column.ValueColumn;
import ru.yandex.solomon.util.collection.array.DoubleArrayView;
import ru.yandex.solomon.util.collection.array.LongArrayView;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class GraphDataAsAggrIterator extends AggrGraphDataListIterator {
    private static final int MASK = StockpileColumn.TS.mask() | StockpileColumn.VALUE.mask();
    private final LongArrayView timestamps;
    private final DoubleArrayView values;
    private int pos;

    public GraphDataAsAggrIterator(GraphData source) {
        super(MASK);
        this.timestamps = source.getTimestamps();
        this.values = source.getValues();
    }

    @Override
    public int estimatePointsCount() {
        return timestamps.length();
    }

    @Override
    public boolean next(AggrPoint target) {
        if (pos >= timestamps.length()) {
            return false;
        }

        target.columnSet = MASK;
        target.tsMillis = timestamps.at(pos);
        target.valueNum = values.at(pos);
        target.valueDenom = ValueColumn.DEFAULT_DENOM;
        pos++;
        return true;
    }
}
