package ru.yandex.solomon.model.timeseries;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;

/**
 * @author Vladimir Gordiychuk
 */
public class MergingAggrGraphDataIterable implements AggrGraphDataIterable {
    private final AggrGraphDataIterable[] sources;

    private MergingAggrGraphDataIterable(AggrGraphDataIterable[] sources) {
        this.sources = sources;
    }

    public static AggrGraphDataIterable of(List<? extends AggrGraphDataIterable> sources) {
        if (sources.size() == 1) {
            return sources.get(0);
        }

        AggrGraphDataIterable[] nonEmpty = sources.stream()
            .filter(it -> !it.isEmpty())
            .toArray(AggrGraphDataIterable[]::new);

        if (nonEmpty.length == 1) {
            return nonEmpty[0];
        }

        return new MergingAggrGraphDataIterable(nonEmpty);
    }

    @Override
    public int getRecordCount() {
        int max = 0;
        for (AggrGraphDataIterable source : sources) {
            max = Math.max(max, source.getRecordCount());
        }

        return max;
    }

    @Override
    public int elapsedBytes() {
        int bytes = 0;
        for (var source : sources) {
            bytes += source.elapsedBytes();
        }
        return bytes;
    }

    @Nonnull
    @Override
    public AggrGraphDataListIterator iterator() {
        List<AggrGraphDataListIterator> iterators = new ArrayList<>(sources.length);
        for (AggrGraphDataIterable source : sources) {
            iterators.add(source.iterator());
        }

        return MergingAggrGraphDataIterator.ofMaxAggregate(iterators);
    }

    @Override
    public int columnSetMask() {
        int mask = 0;
        for (AggrGraphDataIterable source : sources) {
            mask |= source.columnSetMask();
        }

        return mask;
    }
}
