package ru.yandex.solomon.model.timeseries;

import java.util.stream.LongStream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.time.DurationUtils;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class TimelineUtils {

    public static long[] secondsToMillis(long[] seconds) {
        return LongStream.of(seconds).map(DurationUtils::secondsToMillis).toArray();
    }

    public static long[] millisToSeconds(long[] millis) {
        return LongStream.of(millis).map(DurationUtils::millisToSeconds).toArray();
    }

    public interface CommonTimelineVisitor {
        void visitBoth(long ts, int ai, int bi);
        void visitLeft(long ts, int ai);
        void visitRight(long ts, int bi);
    }

    public static void visitCommonTimeline(Timeline a, Timeline b, CommonTimelineVisitor visitor) {
        int ai = 0;
        int bi = 0;
        while (ai < a.length() && bi < b.length()) {
            long at = a.getPointsMillis().at(ai);
            long bt = b.getPointsMillis().at(bi);

            if (at == bt) {
                visitor.visitBoth(at, ai, bi);
                ++ai;
                ++bi;
            } else if (at < bt) {
                visitor.visitLeft(at, ai);
                ++ai;
            } else {
                visitor.visitRight(bt, bi);
                ++bi;
            }
        }

        while (ai < a.length()) {
            long at = a.getPointsMillis().at(ai);
            visitor.visitLeft(at, ai);
            ++ai;
        }
        while (bi < b.length()) {
            long bt = b.getPointsMillis().at(bi);
            visitor.visitRight(bt, bi);
            ++bi;
        }
    }
}
