package ru.yandex.solomon.model.timeseries;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.type.Histogram;
import ru.yandex.solomon.model.type.LogHistogram;
import ru.yandex.solomon.model.type.MutableLogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class TransferHistToLogHistogramIterator extends AggrGraphDataListIterator {
    private final AggrGraphDataListIterator source;
    private final MutableLogHistogram mutable = new MutableLogHistogram();

    public TransferHistToLogHistogramIterator(int mask, AggrGraphDataListIterator source) {
        super(mask);
        this.source = source;
    }

    @Override
    public int estimatePointsCount() {
        return source.estimatePointsCount();
    }

    @Override
    public boolean next(AggrPoint target) {
        if (!source.next(target)) {
            return false;
        }

        var from = target.histogram;
        var to = LogHistogram.orNew(target.logHistogram);
        if (from == null) {
            target.setLogHistogram(to);
            target.columnSet = columnSetMask();
            return true;
        }

        convert(from, to);
        target.setLogHistogram(to);
        target.columnSet = columnSetMask();
        return true;
    }

    private void convert(Histogram from, LogHistogram to) {
        for (int index = 0; index < from.count(); index++) {
            long count = from.value(index);
            double upperBound = from.upperBound(index);
            if (count <= 0) {
                continue;
            }
            if (Double.compare(upperBound, Histograms.INF_BOUND) >= 0) {
                continue;
            }
            mutable.addValue(upperBound - 0.01, count);
        }
        mutable.build(to);
        mutable.reset();
    }
}
