package ru.yandex.solomon.model.timeseries.aggregation;

import ru.yandex.solomon.math.protobuf.Aggregation;

/**
 * @author Vladimir Gordiychuk
 */
public class DoubleSummary extends TimeseriesSummary {
    private double max;
    private double min;
    private double sum;
    private double avg;
    private double last;

    public double getMax() {
        return max;
    }

    public void setMax(double max) {
        this.max = max;
        appendMask(Aggregation.MAX);
    }

    public double getMin() {
        return min;
    }

    public void setMin(double min) {
        this.min = min;
        appendMask(Aggregation.MIN);
    }

    public double getSum() {
        return sum;
    }

    public void setSum(double sum) {
        this.sum = sum;
        appendMask(Aggregation.SUM);
    }

    public double getAvg() {
        return avg;
    }

    public void setAvg(double avg) {
        this.avg = avg;
        appendMask(Aggregation.AVG);
    }

    public double getLast() {
        return last;
    }

    public void setLast(double last) {
        this.last = last;
        appendMask(Aggregation.LAST);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DoubleSummary that = (DoubleSummary) o;

        if (Double.compare(that.max, max) != 0) return false;
        if (Double.compare(that.min, min) != 0) return false;
        if (Double.compare(that.sum, sum) != 0) return false;
        if (Double.compare(that.avg, avg) != 0) return false;
        return Double.compare(that.last, last) == 0;
    }

    @Override
    public int hashCode() {
        int result;
        long temp;
        temp = Double.doubleToLongBits(max);
        result = (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(min);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(sum);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(avg);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(last);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        return result;
    }
}
