package ru.yandex.solomon.model.timeseries.aggregation;

import javax.annotation.Nullable;

import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.type.Histogram;

/**
 * @author Vladimir Gordiychuk
 */
public class HistogramSummary extends TimeseriesSummary {
    @Nullable
    private Histogram sum;
    @Nullable
    private Histogram last;

    @Nullable
    public Histogram getSum() {
        return sum;
    }

    public void setSum(Histogram sum) {
        this.sum = sum;
        appendMask(Aggregation.SUM);
    }

    @Nullable
    public Histogram getLast() {
        return last;
    }

    public void setLast(Histogram last) {
        this.last = last;
        appendMask(Aggregation.LAST);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        HistogramSummary that = (HistogramSummary) o;
        if (sum != null ? !sum.equals(that.sum) : that.sum != null) return false;
        return last != null ? last.equals(that.last) : that.last == null;
    }

    @Override
    public int hashCode() {
        int result = sum != null ? sum.hashCode() : 0;
        result = 31 * result + (last != null ? last.hashCode() : 0);
        return result;
    }
}
