package ru.yandex.solomon.model.timeseries.aggregation;

import ru.yandex.solomon.math.protobuf.Aggregation;

/**
 * @author Vladimir Gordiychuk
 */
public class Int64Summary extends TimeseriesSummary {
    private long max;
    private long min;
    private long sum;
    private long last;
    private long avg;

    public long getMax() {
        return max;
    }

    public void setMax(long max) {
        this.max = max;
        appendMask(Aggregation.MAX);
    }

    public long getMin() {
        return min;
    }

    public void setMin(long min) {
        this.min = min;
        appendMask(Aggregation.MIN);
    }

    public long getSum() {
        return sum;
    }

    public void setSum(long sum) {
        this.sum = sum;
        appendMask(Aggregation.SUM);
    }

    public long getAvg() {
        return avg;
    }

    public void setAvg(long avg) {
        this.avg = avg;
        appendMask(Aggregation.AVG);
    }

    public long getLast() {
        return last;
    }

    public void setLast(long last) {
        this.last = last;
        appendMask(Aggregation.LAST);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Int64Summary that = (Int64Summary) o;

        if (max != that.max) return false;
        if (min != that.min) return false;
        if (sum != that.sum) return false;
        if (last != that.last) return false;
        return Double.compare(that.avg, avg) == 0;
    }

    @Override
    public int hashCode() {
        int result;
        long temp;
        result = (int) (max ^ (max >>> 32));
        result = 31 * result + (int) (min ^ (min >>> 32));
        result = 31 * result + (int) (sum ^ (sum >>> 32));
        result = 31 * result + (int) (last ^ (last >>> 32));
        temp = Double.doubleToLongBits(avg);
        result = 31 * result + (int) (temp ^ (temp >>> 32));
        return result;
    }
}
