package ru.yandex.solomon.model.timeseries.aggregation;

import javax.annotation.Nullable;

import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Sergey Polovko
 */
public class LogHistogramSummary extends TimeseriesSummary {
    @Nullable
    private LogHistogram sum;
    @Nullable
    private LogHistogram last;

    @Nullable
    public LogHistogram getSum() {
        return sum;
    }

    public void setSum(LogHistogram sum) {
        this.sum = sum;
        appendMask(Aggregation.SUM);
    }

    @Nullable
    public LogHistogram getLast() {
        return last;
    }

    public void setLast(LogHistogram last) {
        this.last = last;
        appendMask(Aggregation.LAST);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        LogHistogramSummary that = (LogHistogramSummary) o;
        if (sum != null ? !sum.equals(that.sum) : that.sum != null) return false;
        return last != null ? last.equals(that.last) : that.last == null;
    }

    @Override
    public int hashCode() {
        int result = sum != null ? sum.hashCode() : 0;
        result = 31 * result + (last != null ? last.hashCode() : 0);
        return result;
    }
}
