package ru.yandex.solomon.model.timeseries.aggregation;

import javax.annotation.Nullable;

import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;
import ru.yandex.solomon.math.protobuf.Aggregation;

/**
 * @author Vladimir Gordiychuk
 */
public class SummaryInt64Summary extends TimeseriesSummary {
    @Nullable
    private SummaryInt64Snapshot sum;
    @Nullable
    private SummaryInt64Snapshot last;

    @Nullable
    public SummaryInt64Snapshot getSum() {
        return sum;
    }

    public void setSum(SummaryInt64Snapshot sum) {
        this.sum = sum;
        appendMask(Aggregation.SUM);
    }

    @Nullable
    public SummaryInt64Snapshot getLast() {
        return last;
    }

    public void setLast(SummaryInt64Snapshot last) {
        this.last = last;
        appendMask(Aggregation.LAST);
    }

    @Override
    public void setMask(int mask) {
        super.setMask(mask);

        if (!has(Aggregation.SUM)) {
            sum = null;
        }

        if (!has(Aggregation.LAST)) {
            last = null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SummaryInt64Summary that = (SummaryInt64Summary) o;
        if (sum != null ? !sum.equals(that.sum) : that.sum != null) return false;
        return last != null ? last.equals(that.last) : that.last == null;
    }

    @Override
    public int hashCode() {
        int result = sum != null ? sum.hashCode() : 0;
        result = 31 * result + (last != null ? last.hashCode() : 0);
        return result;
    }
}
