package ru.yandex.solomon.model.timeseries.aggregation;

import ru.yandex.solomon.math.protobuf.Aggregation;

/**
 * @author Vladimir Gordiychuk
 */
public abstract class TimeseriesSummary {
    private int mask = mask(Aggregation.COUNT);
    private long count;

    public boolean has(Aggregation aggregation) {
        return (mask & (1 << aggregation.getNumber())) != 0;
    }

    public int getMask() {
        return mask;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    public long getCount() {
        return count;
    }

    public void setCount(long count) {
        this.count = count;
        appendMask(Aggregation.COUNT);
    }

    protected void appendMask(Aggregation aggregation) {
        this.mask |= mask(aggregation);
    }

    private int mask(Aggregation aggregation) {
        return 1 << aggregation.getNumber();
    }

    @Override
    public String toString() {
        return "TimeseriesSummary{mask=" + mask + ", count=" + count + '}';
    }
}
