package ru.yandex.solomon.model.timeseries.aggregation.collectors;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.ValueColumn;

/**
 * Compatible with old approach for decim rate metrics wrote as num/denom
 *
 * @author Vladimir Gordiychuk
 */
public class NumDenomAverageDoublePointCollector implements PointValueCollector {
    private long count;
    private double num;
    private long denom;

    @Override
    public void reset() {
        count = 0;
        num = ValueColumn.DEFAULT_VALUE;
        denom = ValueColumn.DEFAULT_DENOM;
    }

    @Override
    public void append(AggrPoint point) {
        if (num == 0) {
            // special case to avoid losing of denom
            // if denoms are different
            num = point.valueNum;
            denom = point.valueDenom;
        } else if (ValueColumn.isOne(denom)) {
            // denom is lost, so the num is probably a random junk
            // so we won't loose anything using 1 as denom
            num += point.getValueDivided();
        } else if (denom == point.valueDenom) {
            // happiest case
            num += point.valueNum;
        } else {
            // we could probably use LCD here
            num = ValueColumn.divide(num, denom);
            denom = ValueColumn.DEFAULT_DENOM;
            num += point.getValueDivided();
        }

        count++;
    }

    @Override
    public boolean compute(AggrPoint point) {
        if (count == 0) {
            point.valueNum = Double.NaN;
            point.valueDenom = ValueColumn.DEFAULT_DENOM;
            return false;
        }

        if (count == 1) {
            point.valueNum = num;
            point.valueDenom = denom;
            return true;
        }

        if (ValueColumn.isOne(denom)) {
            point.valueNum = num / count;
            point.valueDenom = ValueColumn.DEFAULT_DENOM;
            return true;
        }

        point.valueNum = num;
        point.valueDenom = denom * count;
        return true;
    }
}
