package ru.yandex.solomon.model.timeseries.aggregation.collectors;

import ru.yandex.solomon.model.point.AggrPoint;

/**
 * @author Vladimir Gordiychuk
 */
public interface PointValueCollector {
    /**
     * Reset collected state
     */
    void reset();

    /**
     * Append point into collector to reduce it into one point
     */
    void append(AggrPoint point);

    /**
     * Reduce collected points into one
     */
    boolean compute(AggrPoint point);
}
