package ru.yandex.solomon.model.timeseries.aggregation.collectors;

import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.protobuf.MetricType;

/**
 * @author Vladimir Gordiychuk
 */
public final class PointValueCollectors {
    private PointValueCollectors() {
    }

    public static PointValueCollector of(MetricType type, Aggregation aggregation) {
        switch (type) {
            case DGAUGE:
            case METRIC_TYPE_UNSPECIFIED:
                return DoublePointCollectors.ofDouble(aggregation);
            case IGAUGE:
                return LongPointCollectors.ofGauge(aggregation);
            case COUNTER:
                return LongPointCollectors.ofCounter(aggregation);
            case RATE:
                return LongPointCollectors.ofRate(aggregation);
            case LOG_HISTOGRAM:
                return LogHistogramPointCollectors.ofLogHistogram(aggregation);
            case HIST:
            case HIST_RATE:
                return UgramPointValueCollectors.ofHistogram(aggregation);
            case DSUMMARY:
                return SummaryDoublePointCollectors.ofSummaryDouble(aggregation);
            case ISUMMARY:
                return SummaryInt64PointCollectors.ofSummaryInt64(aggregation);
            default:
                throw new UnsupportedOperationException("Unsupported type " + type + " for aggregation: " + aggregation);
        }
    }
}
