package ru.yandex.solomon.model.timeseries.aggregation.collectors;

import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.type.ugram.Ugram;

/**
 * @author Vladimir Gordiychuk
 */
public class UgramPointValueCollectors {
    public static PointValueCollector ofHistogram(Aggregation aggregation) {
        switch (aggregation) {
            case DEFAULT_AGGREGATION:
            case SUM:
                return new UgramCollector();
            default:
                return HistogramPointCollectors.ofHistogram(aggregation);
        }
    }

    private static class UgramCollector implements PointValueCollector {
        private long count = 0;
        private Ugram ugram = Ugram.create();

        @Override
        public void reset() {
            count = 0;
            ugram.reset();
        }

        @Override
        public void append(AggrPoint point) {
            count += Math.max(1, point.count);
            ugram.merge(point.histogram);
        }

        @Override
        public boolean compute(AggrPoint point) {
            point.setCount(count);
            if (count == 0) {
                if (point.histogram != null) {
                    point.histogram.reset();
                }
                return false;
            }

            point.setHistogram(ugram.snapshot(point.histogram));
            return true;
        }
    }
}
