package ru.yandex.solomon.model.timeseries.aggregation.collectors.summary;

import java.util.List;
import java.util.function.Function;

import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.PointValueCollector;

/**
 * @author Vladimir Gordiychuk
 */
public abstract class AbstractSummaryCollector implements SummaryCollector {
    protected final List<Aggregation> aggregations;
    protected final PointValueCollector[] collectors;

    public AbstractSummaryCollector(List<Aggregation> aggregations, Function<Aggregation, PointValueCollector> fn) {
        this.aggregations = aggregations;
        this.collectors = aggregations.stream()
                .map(fn)
                .toArray(PointValueCollector[]::new);
    }

    @Override
    public void append(AggrPoint point) {
        for (PointValueCollector collector : collectors) {
            collector.append(point);
        }
    }
}
