package ru.yandex.solomon.model.timeseries.aggregation.collectors.summary;

import java.util.List;

import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.aggregation.DoubleSummary;
import ru.yandex.solomon.model.timeseries.aggregation.TimeseriesSummary;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.DoublePointCollectors;

/**
 * @author Vladimir Gordiychuk
 */
public class DoubleSummaryCollector extends AbstractSummaryCollector {
    public DoubleSummaryCollector(List<Aggregation> aggregations) {
        super(aggregations, DoublePointCollectors::ofDouble);
    }

    @Override
    public TimeseriesSummary compute() {
        AggrPoint point = new AggrPoint();

        DoubleSummary summary = new DoubleSummary();
        for (int index = 0; index < collectors.length; index++) {
            Aggregation aggregation = aggregations.get(index);
            double value = collectors[index].compute(point)
                    ? point.getValueDivided()
                    : 0;

            switch (aggregation) {
                case DEFAULT_AGGREGATION:
                case MAX:
                    summary.setMax(value);
                    break;
                case MIN:
                    summary.setMin(value);
                    break;
                case SUM:
                    summary.setSum(value);
                    break;
                case AVG:
                    summary.setAvg(value);
                    break;
                case LAST:
                    summary.setLast(value);
                    break;
                default:
                    throw new UnsupportedOperationException("Unsupported double aggregation: " + aggregation);
            }

            summary.setCount(point.count);
        }

        return summary;
    }
}
