package ru.yandex.solomon.model.timeseries.aggregation.collectors.summary;

import java.util.List;

import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.aggregation.HistogramSummary;
import ru.yandex.solomon.model.timeseries.aggregation.TimeseriesSummary;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.HistogramPointCollectors;
import ru.yandex.solomon.model.type.Histogram;

/**
 * @author Vladimir Gordiychuk
 */
public class HistogramSummaryCollector extends AbstractSummaryCollector {
    public HistogramSummaryCollector(List<Aggregation> aggregations) {
        super(aggregations, HistogramPointCollectors::ofHistogram);
    }

    @Override
    public TimeseriesSummary compute() {
        AggrPoint point = new AggrPoint();

        HistogramSummary summary = new HistogramSummary();
        for (int index = 0; index < collectors.length; index++) {
            Aggregation aggregation = aggregations.get(index);
            Histogram value = collectors[index].compute(point)
                    ? Histogram.copyOf(point.histogram)
                    : null;

            switch (aggregation) {
                case DEFAULT_AGGREGATION:
                case SUM:
                    summary.setSum(value);
                    break;
                case LAST:
                    summary.setLast(value);
                    break;
                default:
                    throw new UnsupportedOperationException("Unsupported histogram aggregation: " + aggregation);
            }

            summary.setCount(point.count);
        }

        return summary;
    }
}
