package ru.yandex.solomon.model.timeseries.aggregation.collectors.summary;

import java.util.List;
import java.util.function.Function;

import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.aggregation.Int64Summary;
import ru.yandex.solomon.model.timeseries.aggregation.TimeseriesSummary;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.PointValueCollector;

/**
 * @author Vladimir Gordiychuk
 */
public class Int64SummaryCollector extends AbstractSummaryCollector {
    public Int64SummaryCollector(List<Aggregation> aggregations, Function<Aggregation, PointValueCollector> fn) {
        super(aggregations, fn);
    }

    @Override
    public TimeseriesSummary compute() {
        AggrPoint point = new AggrPoint();

        Int64Summary summary = new Int64Summary();
        for (int index = 0; index < collectors.length; index++) {
            Aggregation aggregation = aggregations.get(index);
            long value = collectors[index].compute(point)
                ? point.longValue
                : 0;

            switch (aggregation) {
                case DEFAULT_AGGREGATION:
                case MAX:
                    summary.setMax(value);
                    break;
                case MIN:
                    summary.setMin(value);
                    break;
                case SUM:
                    summary.setSum(value);
                    break;
                case AVG:
                    summary.setAvg(value);
                    break;
                case LAST:
                    summary.setLast(value);
                    break;
                default:
                    throw new UnsupportedOperationException("Unsupported int64 aggregation: " + aggregation);
            }

            summary.setCount(point.count);
        }

        return summary;
    }
}
