package ru.yandex.solomon.model.timeseries.aggregation.collectors.summary;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.LongPointCollectors;

/**
 * @author Vladimir Gordiychuk
 */
public class SummaryCollectors {
    public static SummaryCollector of(MetricType type, List<Aggregation> aggregations) {
        aggregations = aggregations.stream()
                .filter(a -> !(a == Aggregation.DEFAULT_AGGREGATION || a == Aggregation.COUNT))
                .collect(Collectors.toList());

        switch (type) {
            case COUNTER:
                return new Int64SummaryCollector(aggregations, LongPointCollectors::ofCounter);
            case IGAUGE:
                return new Int64SummaryCollector(aggregations, LongPointCollectors::ofGauge);
            case DGAUGE:
            case RATE:
            case METRIC_TYPE_UNSPECIFIED:
                return new DoubleSummaryCollector(aggregations);
            case HIST:
            case HIST_RATE:
                return new HistogramSummaryCollector(aggregations);
            case ISUMMARY:
                return new SummaryInt64SummaryCollector(aggregations);
            case DSUMMARY:
                return new SummaryDoubleSummaryCollector(aggregations);
            default:
                throw new UnsupportedOperationException("Unsupported type " + type + " for aggregation " + aggregations);
        }
    }
}
