package ru.yandex.solomon.model.timeseries.aggregation.collectors.summary;

import java.util.List;

import ru.yandex.monlib.metrics.summary.SummaryDoubleSnapshot;
import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.SummaryDoubleColumn;
import ru.yandex.solomon.model.timeseries.aggregation.SummaryDoubleSummary;
import ru.yandex.solomon.model.timeseries.aggregation.TimeseriesSummary;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.SummaryDoublePointCollectors;

/**
 * @author Vladimir Gordiychuk
 */
public class SummaryDoubleSummaryCollector extends AbstractSummaryCollector {
    public SummaryDoubleSummaryCollector(List<Aggregation> aggregations) {
        super(aggregations, SummaryDoublePointCollectors::ofSummaryDouble);
    }

    @Override
    public TimeseriesSummary compute() {
        AggrPoint point = new AggrPoint();

        SummaryDoubleSummary summary = new SummaryDoubleSummary();
        for (int index = 0; index < collectors.length; index++) {
            Aggregation aggregation = aggregations.get(index);
            SummaryDoubleSnapshot value = collectors[index].compute(point)
                    ? SummaryDoubleColumn.copy(point.summaryDouble)
                    : null;

            switch (aggregation) {
                case DEFAULT_AGGREGATION:
                case SUM:
                    summary.setSum(value);
                    break;
                case LAST:
                    summary.setLast(value);
                    break;
                default:
                    throw new UnsupportedOperationException("Unsupported SummaryDouble aggregation: " + aggregation);
            }

            summary.setCount(point.count);
        }

        return summary;
    }
}
