package ru.yandex.solomon.model.timeseries.aggregation.collectors.summary;

import java.util.List;

import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;
import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.aggregation.SummaryInt64Summary;
import ru.yandex.solomon.model.timeseries.aggregation.TimeseriesSummary;
import ru.yandex.solomon.model.timeseries.aggregation.collectors.SummaryInt64PointCollectors;

/**
 * @author Vladimir Gordiychuk
 */
public class SummaryInt64SummaryCollector extends AbstractSummaryCollector {
    public SummaryInt64SummaryCollector(List<Aggregation> aggregations) {
        super(aggregations, SummaryInt64PointCollectors::ofSummaryInt64);
    }

    @Override
    public TimeseriesSummary compute() {
        AggrPoint point = new AggrPoint();

        SummaryInt64Summary summary = new SummaryInt64Summary();
        for (int index = 0; index < collectors.length; index++) {
            Aggregation aggregation = aggregations.get(index);
            SummaryInt64Snapshot value = collectors[index].compute(point)
                    ? point.summaryInt64
                    : null;

            switch (aggregation) {
                case DEFAULT_AGGREGATION:
                case SUM:
                    summary.setSum(value);
                    break;
                case LAST:
                    summary.setLast(value);
                    break;
                default:
                    throw new UnsupportedOperationException("Unsupported SummaryInt64 aggregation: " + aggregation);
            }

            summary.setCount(point.count);
        }

        return summary;
    }
}
