package ru.yandex.solomon.model.timeseries.decim;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Vladimir Gordiychuk
 */
public class DecimPolicyBuilder {
    private List<DecimPolicyItem> items = new ArrayList<>();

    public DecimPolicyBuilder addPolicy(Duration age, Duration step) {
        items.add(new DecimPolicyItem(age.toMillis(), Math.toIntExact(step.toMillis())));
        return this;
    }

    public After after(Duration age) {
        return new After(age);
    }

    public DecimPolicy build() {
        return new DecimPolicy(items.toArray(new DecimPolicyItem[0]));
    }

    public class After {
        private Duration age;

        public After(Duration age) {
            this.age = age;
        }

        public DecimPolicyBuilder to(Duration step) {
            return addPolicy(age, step);
        }
    }
}
