package ru.yandex.solomon.model.timeseries.iterator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AggrPointCursor implements GenericCursor<AggrPoint> {
    private final AggrGraphDataListIterator iterator;
    private final AggrPoint point;

    public AggrPointCursor(AggrGraphDataListIterator iterator) {
        this.iterator = iterator;
        this.point = new AggrPoint(iterator.columnSetMask());
    }

    @Override
    public long getTimestamp() {
        return point.tsMillis;
    }

    @Override
    public boolean next() {
        return iterator.next(point);
    }

    @Override
    public AggrGraphDataListIterator getIterator() {
        return iterator;
    }

    public AggrPoint getPoint() {
        return point;
    }
}
